<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// API Version 1 Routes
Route::prefix('v1')->group(function () {
    // Public routes
    Route::post('/auth/register', [App\Http\Controllers\Api\V1\AuthController::class, 'register']);
    Route::post('/auth/login', [App\Http\Controllers\Api\V1\AuthController::class, 'login']);
    Route::post('/auth/password/reset', [App\Http\Controllers\Api\V1\AuthController::class, 'resetPassword']);
    Route::post('/auth/password/reset/verify', [App\Http\Controllers\Api\V1\AuthController::class, 'verifyResetToken']);
    
    // Protected routes
    Route::middleware('auth:sanctum')->group(function () {
        // Auth routes
        Route::post('/auth/logout', [App\Http\Controllers\Api\V1\AuthController::class, 'logout']);
        Route::post('/auth/email/verify', [App\Http\Controllers\Api\V1\AuthController::class, 'verifyEmail']);
        Route::post('/auth/mfa/setup', [App\Http\Controllers\Api\V1\AuthController::class, 'setupMfa']);
        
        // User routes
        Route::get('/user/profile', [App\Http\Controllers\Api\V1\UserController::class, 'profile']);
        Route::put('/user/profile', [App\Http\Controllers\Api\V1\UserController::class, 'updateProfile']);
        
        // KYC routes
        Route::post('/kyc/documents', [App\Http\Controllers\Api\V1\KycController::class, 'uploadDocument']);
        Route::post('/kyc/selfie', [App\Http\Controllers\Api\V1\KycController::class, 'uploadSelfie']);
        Route::get('/kyc/status', [App\Http\Controllers\Api\V1\KycController::class, 'status']);
        
        // Vehicle routes
        Route::apiResource('vehicles', App\Http\Controllers\Api\V1\VehicleController::class);
        
        // Policy routes
        Route::post('/policies/quote', [App\Http\Controllers\Api\V1\PolicyController::class, 'getQuote']);
        Route::apiResource('policies', App\Http\Controllers\Api\V1\PolicyController::class);
        Route::post('/policies/{policy}/activate', [App\Http\Controllers\Api\V1\PolicyController::class, 'activate']);
        Route::post('/policies/{policy}/deactivate', [App\Http\Controllers\Api\V1\PolicyController::class, 'deactivate']);
        
        // Session routes
        Route::post('/sessions/start', [App\Http\Controllers\Api\V1\SessionController::class, 'start']);
        Route::post('/sessions/{session}/stop', [App\Http\Controllers\Api\V1\SessionController::class, 'stop']);
        Route::get('/sessions/active', [App\Http\Controllers\Api\V1\SessionController::class, 'active']);
        Route::get('/sessions', [App\Http\Controllers\Api\V1\SessionController::class, 'index']);
        Route::get('/sessions/{session}', [App\Http\Controllers\Api\V1\SessionController::class, 'show']);
        Route::post('/sessions/{session}/location', [App\Http\Controllers\Api\V1\SessionController::class, 'updateLocation']);
        
        // Wallet routes
        Route::get('/wallet/balance', [App\Http\Controllers\Api\V1\WalletController::class, 'balance']);
        Route::post('/wallet/topup', [App\Http\Controllers\Api\V1\WalletController::class, 'topUp']);
        Route::get('/wallet/transactions', [App\Http\Controllers\Api\V1\WalletController::class, 'transactions']);
        Route::put('/wallet/auto-topup', [App\Http\Controllers\Api\V1\WalletController::class, 'updateAutoTopUp']);
        
        // Document routes
        Route::get('/documents', [App\Http\Controllers\Api\V1\DocumentController::class, 'index']);
        Route::get('/documents/{document}/download', [App\Http\Controllers\Api\V1\DocumentController::class, 'download']);
        
        // Claim routes
        Route::post('/claims', [App\Http\Controllers\Api\V1\ClaimController::class, 'store']);
        Route::get('/claims', [App\Http\Controllers\Api\V1\ClaimController::class, 'index']);
        Route::get('/claims/{claim}', [App\Http\Controllers\Api\V1\ClaimController::class, 'show']);
        Route::post('/claims/{claim}/evidence', [App\Http\Controllers\Api\V1\ClaimController::class, 'uploadEvidence']);
        
        // Work Provider routes
        Route::apiResource('work-providers', App\Http\Controllers\Api\V1\WorkProviderController::class);
        Route::post('/work-providers/{workProvider}/link', [App\Http\Controllers\Api\V1\WorkProviderController::class, 'link']);
        Route::post('/work-providers/{workProvider}/unlink', [App\Http\Controllers\Api\V1\WorkProviderController::class, 'unlink']);
        
        // Notification routes
        Route::get('/notifications', [App\Http\Controllers\Api\V1\NotificationController::class, 'index']);
        Route::put('/notifications/{notification}/read', [App\Http\Controllers\Api\V1\NotificationController::class, 'markAsRead']);
        Route::post('/notifications/token', [App\Http\Controllers\Api\V1\NotificationController::class, 'registerToken']);
        Route::put('/notifications/preferences', [App\Http\Controllers\Api\V1\NotificationController::class, 'updatePreferences']);
    });
});

