<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\WorkProvider;
use Illuminate\Database\Seeder;

class WorkProviderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = User::all();
        $providers = ['uber_eats', 'just_eat', 'deliveroo', 'amazon_flex'];

        foreach ($users as $user) {
            // Each user gets 1-3 work providers
            $providerCount = rand(1, 3);
            $selectedProviders = array_rand($providers, min($providerCount, count($providers)));
            
            if (!is_array($selectedProviders)) {
                $selectedProviders = [$selectedProviders];
            }
            
            foreach ($selectedProviders as $providerIndex) {
                WorkProvider::create([
                    'user_id' => $user->id,
                    'provider' => $providers[$providerIndex],
                    'provider_user_id' => 'PROV-' . strtoupper(uniqid()),
                    'provider_token' => 'token_' . strtoupper(uniqid()),
                    'is_active' => rand(0, 1) === 1,
                    'auto_sync_enabled' => rand(0, 1) === 1,
                ]);
            }
        }
    }
}
