<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Vehicle;
use Illuminate\Database\Seeder;

class VehicleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = User::all();
        
        $vehicleTypes = ['car', 'van', 'scooter', 'motorbike'];
        $makes = ['Toyota', 'Ford', 'Honda', 'Yamaha', 'Vespa', 'Mercedes'];
        $models = ['Corolla', 'Focus', 'Civic', 'MT-07', 'GTS', 'Sprinter'];
        $colors = ['Red', 'Blue', 'Black', 'White', 'Silver', 'Green'];

        foreach ($users as $user) {
            // Each user gets 1-3 vehicles
            $vehicleCount = rand(1, 3);
            
            for ($i = 0; $i < $vehicleCount; $i++) {
                Vehicle::create([
                    'user_id' => $user->id,
                    'type' => $vehicleTypes[array_rand($vehicleTypes)],
                    'make' => $makes[array_rand($makes)],
                    'model' => $models[array_rand($models)],
                    'registration_number' => strtoupper(substr(md5(uniqid()), 0, 2)) . rand(1000, 9999) . strtoupper(substr(md5(uniqid()), 0, 3)),
                    'year' => rand(2015, 2024),
                    'color' => $colors[array_rand($colors)],
                    'is_active' => rand(0, 1) === 1,
                ]);
            }
        }
    }
}
