<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Wallet;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create test users with different KYC statuses
        $users = [
            [
                'name' => 'John Doe',
                'email' => 'john@example.com',
                'phone' => '+441234567890',
                'password' => Hash::make('password123'),
                'kyc_status' => 'verified',
                'language' => 'en',
            ],
            [
                'name' => 'Jane Smith',
                'email' => 'jane@example.com',
                'phone' => '+441234567891',
                'password' => Hash::make('password123'),
                'kyc_status' => 'pending',
                'language' => 'en',
            ],
            [
                'name' => 'Bob Johnson',
                'email' => 'bob@example.com',
                'phone' => '+441234567892',
                'password' => Hash::make('password123'),
                'kyc_status' => 'rejected',
                'kyc_notes' => 'Document verification failed',
                'language' => 'en',
            ],
            [
                'name' => 'Alice Williams',
                'email' => 'alice@example.com',
                'phone' => '+441234567893',
                'password' => Hash::make('password123'),
                'kyc_status' => 'verified',
                'language' => 'en',
            ],
            [
                'name' => 'Charlie Brown',
                'email' => 'charlie@example.com',
                'phone' => '+441234567894',
                'password' => Hash::make('password123'),
                'kyc_status' => 'under_review',
                'language' => 'en',
            ],
        ];

        foreach ($users as $userData) {
            $user = User::create($userData);
            
            // Create wallet for each user
            Wallet::create([
                'user_id' => $user->id,
                'balance' => rand(0, 200) + 50, // Random balance between 50-250
                'auto_topup_enabled' => rand(0, 1) === 1,
                'auto_topup_threshold' => 10.00,
                'auto_topup_amount' => 20.00,
            ]);
        }
    }
}
