<?php

namespace Database\Seeders;

use App\Models\Policy;
use App\Models\Session;
use Illuminate\Database\Seeder;

class SessionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $policies = Policy::where('product_type', 'PAYG')
            ->where('status', 'active')
            ->get();

        foreach ($policies as $policy) {
            // Create some completed sessions
            $sessionCount = rand(3, 8);
            
            for ($i = 0; $i < $sessionCount; $i++) {
                $startedAt = now()->subDays(rand(1, 30))->subHours(rand(0, 23))->subMinutes(rand(0, 59));
                $durationMinutes = rand(30, 240); // 30 minutes to 4 hours
                $endedAt = $startedAt->copy()->addMinutes($durationMinutes);
                $hourlyRate = 1.20;
                $cost = round(($durationMinutes / 60) * $hourlyRate, 2);
                
                Session::create([
                    'policy_id' => $policy->id,
                    'user_id' => $policy->user_id,
                    'started_at' => $startedAt,
                    'ended_at' => $endedAt,
                    'status' => 'completed',
                    'cost' => $cost,
                    'hourly_rate' => $hourlyRate,
                    'duration_minutes' => $durationMinutes,
                    'distance_km' => round(rand(5, 50) + (rand(0, 99) / 100), 2),
                ]);
            }

            // Create one active session for some policies
            if (rand(0, 1) === 1) {
                Session::create([
                    'policy_id' => $policy->id,
                    'user_id' => $policy->user_id,
                    'started_at' => now()->subHours(rand(1, 3))->subMinutes(rand(0, 59)),
                    'status' => 'active',
                    'hourly_rate' => 1.20,
                ]);
            }
        }
    }
}
