<?php

namespace Database\Seeders;

use App\Models\Policy;
use App\Models\User;
use Illuminate\Database\Seeder;

class PolicySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = User::where('kyc_status', 'verified')->get();
        
        $productTypes = ['PAYG', '30D', 'ANN'];
        $statuses = ['draft', 'active', 'inactive'];

        foreach ($users as $user) {
            $vehicles = $user->vehicles;
            
            if ($vehicles->isEmpty()) {
                continue;
            }

            // Each verified user gets 1-2 policies
            $policyCount = rand(1, 2);
            
            for ($i = 0; $i < $policyCount; $i++) {
                $productType = $productTypes[array_rand($productTypes)];
                $status = $statuses[array_rand($statuses)];
                
                Policy::create([
                    'user_id' => $user->id,
                    'vehicle_id' => $vehicles->random()->id,
                    'product_type' => $productType,
                    'status' => $status,
                    'premium_amount' => match($productType) {
                        'PAYG' => 1.20,
                        '30D' => 150.00,
                        'ANN' => 1200.00,
                        default => 0,
                    },
                    'start_date' => $status === 'active' ? now()->subDays(rand(1, 30)) : null,
                    'end_date' => $productType === 'ANN' && $status === 'active' ? now()->addYear() : ($productType === '30D' && $status === 'active' ? now()->addDays(30) : null),
                    'policy_number' => 'POL-' . strtoupper(uniqid()),
                    'coverage_details' => [
                        'third_party' => true,
                        'comprehensive' => $productType === 'ANN',
                    ],
                ]);
            }
        }
    }
}
