<?php

namespace Database\Seeders;

use App\Models\KycDocument;
use App\Models\User;
use Illuminate\Database\Seeder;

class KycDocumentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = User::all();
        $documentTypes = ['driving_licence', 'v5c', 'proof_of_address', 'selfie'];
        $verificationStatuses = ['pending', 'verified', 'rejected'];

        foreach ($users as $user) {
            foreach ($documentTypes as $type) {
                $status = $verificationStatuses[array_rand($verificationStatuses)];
                
                KycDocument::create([
                    'user_id' => $user->id,
                    'document_type' => $type,
                    'file_path' => 'kyc_documents/' . $type . '_' . $user->id . '.pdf',
                    'file_name' => ucfirst(str_replace('_', ' ', $type)) . '.pdf',
                    'mime_type' => 'application/pdf',
                    'file_size' => rand(50000, 300000),
                    'verification_status' => $status,
                    'verification_notes' => $status === 'rejected' ? 'Document quality insufficient' : null,
                    'verified_at' => $status === 'verified' ? now()->subDays(rand(1, 30)) : null,
                ]);
            }
        }
    }
}
