<?php

namespace Database\Seeders;

use App\Models\Document;
use App\Models\Policy;
use App\Models\User;
use Illuminate\Database\Seeder;

class DocumentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = User::where('kyc_status', 'verified')->get();
        $documentTypes = ['IPID', 'Policy Schedule', 'Letter of Enrolment', 'Policy Booklet', 'Certificate of Motor Insurance'];

        foreach ($users as $user) {
            $policies = $user->policies()->where('status', 'active')->get();
            
            if ($policies->isEmpty()) {
                continue;
            }

            foreach ($policies as $policy) {
                // Create documents for each policy
                foreach ($documentTypes as $type) {
                    Document::create([
                        'user_id' => $user->id,
                        'policy_id' => $policy->id,
                        'type' => $type,
                        'file_path' => 'documents/' . strtolower(str_replace(' ', '_', $type)) . '_' . $policy->id . '.pdf',
                        'file_name' => $type . '.pdf',
                        'mime_type' => 'application/pdf',
                        'file_size' => rand(100000, 500000),
                        'is_active' => true,
                        'expires_at' => $policy->end_date,
                    ]);
                }
            }
        }
    }
}
