<?php

namespace Database\Seeders;

use App\Models\Claim;
use App\Models\Policy;
use App\Models\User;
use Illuminate\Database\Seeder;

class ClaimSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = User::where('kyc_status', 'verified')->get();
        $statuses = ['pending', 'in_review', 'approved', 'rejected'];

        foreach ($users as $user) {
            $policies = $user->policies()->where('status', 'active')->get();
            
            if ($policies->isEmpty()) {
                continue;
            }

            // Each user gets 0-2 claims
            $claimCount = rand(0, 2);
            
            for ($i = 0; $i < $claimCount; $i++) {
                $policy = $policies->random();
                $status = $statuses[array_rand($statuses)];
                
                Claim::create([
                    'user_id' => $user->id,
                    'policy_id' => $policy->id,
                    'claim_number' => 'CLM-' . strtoupper(uniqid()),
                    'status' => $status,
                    'description' => 'Accident occurred while delivering. Vehicle damage to front bumper.',
                    'incident_date' => now()->subDays(rand(1, 60))->format('Y-m-d'),
                    'incident_location' => 'London, UK',
                    'third_party_details' => [
                        'name' => 'Other Driver',
                        'contact' => '+441234567890',
                    ],
                    'claim_amount' => $status === 'approved' ? rand(500, 5000) : null,
                    'created_at' => now()->subDays(rand(1, 60)),
                ]);
            }
        }
    }
}
