<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone')->nullable()->after('email');
            $table->enum('kyc_status', ['pending', 'verified', 'rejected', 'under_review'])->default('pending')->after('phone');
            $table->text('kyc_notes')->nullable()->after('kyc_status');
            $table->boolean('mfa_enabled')->default(false)->after('kyc_notes');
            $table->string('mfa_secret')->nullable()->after('mfa_enabled');
            $table->string('language', 10)->default('en')->after('mfa_secret');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['phone', 'kyc_status', 'kyc_notes', 'mfa_enabled', 'mfa_secret', 'language']);
        });
    }
};
