<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Vehicle>
 */
class VehicleFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $types = ['car', 'van', 'scooter', 'motorbike'];
        $makes = ['Toyota', 'Ford', 'Honda', 'Yamaha'];
        $models = ['Corolla', 'Focus', 'Civic', 'MT-07'];
        $colors = ['Red', 'Blue', 'Black', 'White'];

        return [
            'user_id' => User::factory(),
            'type' => $types[array_rand($types)],
            'make' => $makes[array_rand($makes)],
            'model' => $models[array_rand($models)],
            'registration_number' => strtoupper(fake()->bothify('??##???')) . rand(100, 999),
            'year' => fake()->numberBetween(2015, 2024),
            'color' => $colors[array_rand($colors)],
            'is_active' => true,
        ];
    }
}
