<?php

namespace Database\Factories;

use App\Models\Policy;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Session>
 */
class SessionFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $statuses = ['active', 'completed', 'cancelled'];
        $status = $statuses[array_rand($statuses)];
        $startedAt = fake()->dateTimeBetween('-30 days', 'now');
        $endedAt = $status === 'completed' ? (clone $startedAt)->modify('+' . rand(30, 240) . ' minutes') : null;
        $durationMinutes = $endedAt ? $startedAt->diff($endedAt)->i + ($startedAt->diff($endedAt)->h * 60) : null;
        $hourlyRate = 1.20;
        $cost = $durationMinutes ? round(($durationMinutes / 60) * $hourlyRate, 2) : 0;

        return [
            'policy_id' => Policy::factory(),
            'user_id' => User::factory(),
            'started_at' => $startedAt,
            'ended_at' => $endedAt,
            'status' => $status,
            'cost' => $cost,
            'hourly_rate' => $hourlyRate,
            'duration_minutes' => $durationMinutes,
            'distance_km' => fake()->randomFloat(2, 5, 50),
            'location_data' => [],
        ];
    }
}
