<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\Vehicle;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Policy>
 */
class PolicyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $productTypes = ['PAYG', '30D', 'ANN'];
        $statuses = ['draft', 'active', 'inactive'];

        return [
            'user_id' => User::factory(),
            'vehicle_id' => Vehicle::factory(),
            'product_type' => $productTypes[array_rand($productTypes)],
            'status' => $statuses[array_rand($statuses)],
            'premium_amount' => fake()->randomFloat(2, 1, 2000),
            'policy_number' => 'POL-' . strtoupper(uniqid()),
            'coverage_details' => [],
        ];
    }
}
