<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('claims', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('policy_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('session_id')->nullable()->constrained()->onDelete('set null');
            $table->string('claim_number')->unique();
            $table->enum('status', ['pending', 'in_review', 'approved', 'rejected', 'settled'])->default('pending');
            $table->text('description');
            $table->string('incident_date');
            $table->string('incident_location')->nullable();
            $table->json('third_party_details')->nullable();
            $table->json('evidence_files')->nullable(); // Array of file paths
            $table->text('notes')->nullable();
            $table->decimal('claim_amount', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('claims');
    }
};
