<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Claim extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'policy_id',
        'session_id',
        'claim_number',
        'status',
        'description',
        'incident_date',
        'incident_location',
        'third_party_details',
        'evidence_files',
        'notes',
        'claim_amount',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'third_party_details' => 'array',
            'evidence_files' => 'array',
            'claim_amount' => 'decimal:2',
        ];
    }

    /**
     * Get the user that owns the claim.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the policy for the claim.
     */
    public function policy(): BelongsTo
    {
        return $this->belongsTo(Policy::class);
    }

    /**
     * Get the session for the claim.
     */
    public function session(): BelongsTo
    {
        return $this->belongsTo(Session::class);
    }
}
